/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCondition;

class WakeupIndexedList
implements Cloneable,
Serializable {
    static final boolean debug = false;
    transient WakeupCondition[] elementData;
    transient Object[] cloneData;
    transient int cloneSize;
    transient boolean isDirty = true;
    Class componentType;
    int size;
    int listType;
    VirtualUniverse univ;

    WakeupIndexedList(int n2, Class clazz, int n3, VirtualUniverse virtualUniverse) {
        this.componentType = clazz;
        this.elementData = (WakeupCondition[])Array.newInstance(clazz, n2);
        this.listType = n3;
        this.univ = virtualUniverse;
    }

    WakeupIndexedList(Class clazz, int n2, VirtualUniverse virtualUniverse) {
        this(10, clazz, n2, virtualUniverse);
    }

    WakeupIndexedList(int n2, int n3, VirtualUniverse virtualUniverse) {
        this(n2, WakeupCondition.class, n3, virtualUniverse);
    }

    WakeupIndexedList(int n2, VirtualUniverse virtualUniverse) {
        this(10, WakeupCondition.class, n2, virtualUniverse);
    }

    static final void init(WakeupCondition wakeupCondition, int n2) {
        wakeupCondition.listIdx = new int[2][n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            wakeupCondition.listIdx[0][i2] = -1;
            wakeupCondition.listIdx[1][i2] = -1;
        }
    }

    final int size() {
        return this.size;
    }

    final int arraySize() {
        return this.cloneSize;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final synchronized boolean contains(WakeupCondition wakeupCondition) {
        return wakeupCondition.listIdx[wakeupCondition.behav.getIdxUsed(this.univ)][this.listType] >= 0;
    }

    final synchronized int indexOf(WakeupCondition wakeupCondition) {
        return wakeupCondition.listIdx[wakeupCondition.behav.getIdxUsed(this.univ)][this.listType];
    }

    protected final synchronized Object clone() {
        try {
            WakeupIndexedList wakeupIndexedList = (WakeupIndexedList)super.clone();
            wakeupIndexedList.elementData = (WakeupCondition[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(this.elementData, 0, wakeupIndexedList.elementData, 0, this.size);
            this.isDirty = true;
            return wakeupIndexedList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    final synchronized Object[] toArray(boolean bl) {
        if (bl) {
            if (this.isDirty) {
                if (this.cloneData == null || this.cloneData.length < this.size) {
                    this.cloneData = (Object[])Array.newInstance(this.componentType, this.size);
                }
                System.arraycopy(this.elementData, 0, this.cloneData, 0, this.size);
                this.cloneSize = this.size;
                this.isDirty = false;
            }
            return this.cloneData;
        }
        this.cloneSize = this.size;
        return this.elementData;
    }

    final synchronized Object[] toArray() {
        return this.toArray(true);
    }

    final synchronized Object[] toArray(WakeupCondition wakeupCondition) {
        int n2 = this.indexOf(wakeupCondition);
        if (n2 < 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        int n3 = this.size - n2;
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, n3);
        System.arraycopy(this.elementData, n2, objectArray, 0, n3);
        return objectArray;
    }

    final synchronized void trimToSize() {
        if (this.elementData.length > this.size) {
            WakeupCondition[] wakeupConditionArray = this.elementData;
            this.elementData = (WakeupCondition[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(wakeupConditionArray, 0, this.elementData, 0, this.size);
        }
    }

    final synchronized Object get(int n2) {
        return this.elementData[n2];
    }

    final synchronized void set(int n2, WakeupCondition wakeupCondition) {
        WakeupCondition wakeupCondition2 = this.elementData[n2];
        if (wakeupCondition2 != null) {
            wakeupCondition2.listIdx[wakeupCondition2.behav.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
        }
        this.elementData[n2] = wakeupCondition;
        int n3 = wakeupCondition.behav.getIdxUsed(this.univ);
        wakeupCondition.listIdx[n3][this.listType] = n2;
        this.isDirty = true;
    }

    final synchronized void add(WakeupCondition wakeupCondition) {
        if (this.elementData.length == this.size) {
            WakeupCondition[] wakeupConditionArray = this.elementData;
            this.elementData = (WakeupCondition[])Array.newInstance(this.componentType, this.size << 1);
            System.arraycopy(wakeupConditionArray, 0, this.elementData, 0, this.size);
        }
        int n2 = wakeupCondition.behav.getIdxUsed(this.univ);
        int n3 = this.size++;
        this.elementData[n3] = wakeupCondition;
        wakeupCondition.listIdx[n2][this.listType] = n3;
        this.isDirty = true;
    }

    final synchronized void remove(int n2) {
        WakeupCondition wakeupCondition = this.elementData[n2];
        int n3 = wakeupCondition.behav.getIdxUsed(this.univ);
        wakeupCondition.listIdx[n3][this.listType] = -1;
        --this.size;
        if (n2 != this.size) {
            wakeupCondition = this.elementData[this.size];
            wakeupCondition.listIdx[n3][this.listType] = n2;
            this.elementData[n2] = wakeupCondition;
        }
        this.elementData[this.size] = null;
        this.isDirty = true;
    }

    final synchronized Object removeLastElement() {
        WakeupCondition wakeupCondition = this.elementData[--this.size];
        this.elementData[this.size] = null;
        wakeupCondition.listIdx[wakeupCondition.behav.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
        this.isDirty = true;
        return wakeupCondition;
    }

    final synchronized boolean remove(WakeupCondition wakeupCondition) {
        int n2 = wakeupCondition.behav.getIdxUsed(this.univ);
        int n3 = wakeupCondition.listIdx[n2][this.listType];
        if (n3 >= 0) {
            --this.size;
            if (n3 != this.size) {
                WakeupCondition wakeupCondition2;
                this.elementData[n3] = wakeupCondition2 = this.elementData[this.size];
                wakeupCondition2.listIdx[wakeupCondition2.behav.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = n3;
            }
            this.elementData[this.size] = null;
            wakeupCondition.listIdx[n2][this.listType] = -1;
            this.isDirty = true;
            return true;
        }
        return false;
    }

    final synchronized void clear() {
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            WakeupCondition wakeupCondition = this.elementData[i2];
            wakeupCondition.listIdx[wakeupCondition.behav.getIdxUsed((VirtualUniverse)this.univ)][this.listType] = -1;
            this.elementData[i2] = null;
        }
        this.size = 0;
        this.isDirty = true;
    }

    final synchronized void clearMirror() {
        if (this.cloneData != null) {
            for (int i2 = this.cloneData.length - 1; i2 >= 0; --i2) {
                this.cloneData[i2] = null;
            }
        }
        this.cloneSize = 0;
        this.isDirty = true;
    }

    final Class getComponentType() {
        return this.componentType;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.hashCode() + " Size = " + this.size + "[");
        int n2 = this.size - 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            WakeupCondition wakeupCondition = this.elementData[i2];
            if (wakeupCondition != null) {
                stringBuffer.append(this.elementData[i2].toString());
            } else {
                stringBuffer.append("NULL");
            }
            if (i2 == n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectOutputStream.writeObject(this.elementData[i2]);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.elementData = (WakeupCondition[])Array.newInstance(this.componentType, n2);
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.elementData[i2] = (WakeupCondition)objectInputStream.readObject();
        }
    }
}

